// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/data_stream_serialization.mojom
//

package org.chromium.mojom.device.serial;

public final class SerializedDataSender extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public DataSink sink;
    public int fatalErrorValue;

    private SerializedDataSender(int version) {
        super(STRUCT_SIZE, version);
    }

    public SerializedDataSender() {
        this(0);
    }

    public static SerializedDataSender deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static SerializedDataSender decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        SerializedDataSender result = new SerializedDataSender(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.sink = decoder0.readServiceInterface(8, false, DataSink.MANAGER);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.fatalErrorValue = decoder0.readInt(16);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(sink, 8, false, DataSink.MANAGER);
        encoder0.encode(fatalErrorValue, 16);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        SerializedDataSender other = (SerializedDataSender) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sink, other.sink))
            return false;
        if (this.fatalErrorValue != other.fatalErrorValue)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sink);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fatalErrorValue);
        return result;
    }
}

